VERSION 5.00
Begin VB.Form frmDPC_PrdCopy 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "#Copy"
   ClientHeight    =   2535
   ClientLeft      =   45
   ClientTop       =   375
   ClientWidth     =   4560
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2535
   ScaleWidth      =   4560
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Tag             =   "frmDPC_PrdCopy"
   Visible         =   0   'False
   Begin VB.CheckBox chk_BOR 
      Caption         =   "#BOR"
      Height          =   270
      Left            =   405
      TabIndex        =   5
      Tag             =   "chk_BOR"
      Top             =   1365
      Width           =   3495
   End
   Begin VB.CheckBox chk_BOM 
      Caption         =   "#BOM"
      Height          =   270
      Left            =   405
      TabIndex        =   4
      Tag             =   "chk_BOM"
      Top             =   997
      Width           =   3495
   End
   Begin VB.TextBox txt_PRD_Code 
      Height          =   345
      Left            =   1680
      TabIndex        =   3
      Top             =   75
      Width           =   2415
   End
   Begin VB.CheckBox chk_Attributes 
      Caption         =   "#Attributes"
      Height          =   270
      Left            =   405
      TabIndex        =   2
      Tag             =   "chk_Attributes"
      Top             =   630
      Width           =   3495
   End
   Begin VB.CommandButton btn_Validate 
      Height          =   612
      Left            =   3180
      Style           =   1  'Graphical
      TabIndex        =   1
      Tag             =   "btn_Validate"
      Top             =   1830
      Width           =   612
   End
   Begin VB.CommandButton btn_Quit 
      Height          =   612
      Left            =   3855
      Style           =   1  'Graphical
      TabIndex        =   0
      Tag             =   "btn_Quit"
      Top             =   1830
      Width           =   612
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#Copy from"
      Height          =   210
      Left            =   180
      TabIndex        =   6
      Tag             =   "lbl_CopyFrom"
      Top             =   165
      Width           =   1155
   End
End
Attribute VB_Name = "frmDPC_PrdCopy"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F

Private Const C_ERRORRAISE As Long = 2500
Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SCREEN_NAME As String = "frmDPC_PrdCopy"

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Private me_PriceBookType As eDPCPriceBookType
Private ml_U_Code As Long
Private ms_Language_Code As String
Private mc_ScreenLabels As Long
Private mb_InternalInit As Boolean
Private ml_ActiveRow As Long
Private mo_Tools As DPC_Tools

#If ENV = LIVE Then
Private mo_Db As Object
Private mo_FSO As Object
#Else
Private mo_Db As ARMSYSCOMLib.ArmDb
Private mo_FSO As FileSystemObject
#End If

Public Result As Boolean
Public PRD_Code As String
Public PRD_Id As String
Public CopyAttributes As Boolean
Public CopyBOM As Boolean
Public CopyBOR As Boolean

Property Let Language_Code(AString As String)
  ms_Language_Code = AString
End Property

Property Get Language_Code() As String
  Language_Code = ms_Language_Code
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
  If Not (lo_Db Is Nothing) Then
      Set mo_Db = lo_Db
  End If
End Property

Property Let U_Code(al_Code As Long)

  ml_U_Code = al_Code
End Property

Public Sub Load_A_COM()
On Error GoTo ErrHandler
    
Dim ls_req As String
  
  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  
  btn_Validate.Picture = LoadResPicture(RES_OK, 1)
  btn_Quit.Picture = LoadResPicture(RES_QUIT, 1)
  Set mo_FSO = New FileSystemObject
  
  PRD_Id = ""
  PRD_Code = ""
  CopyAttributes = False
  CopyBOM = False
  CopyBOR = False
  Result = False
  
  Call mo_Tools.Load_A_ComControls(Me.Controls, mo_Db, ms_Language_Code)
  
  'Screen csts
  mc_ScreenLabels = mo_Tools.LoadLabels(mo_Db, Me.Controls, Me, SCREEN_NAME, ms_Language_Code)
  Call mo_Tools.ChangeCharset(Me.Controls, gl_CodePage, gl_CodePage, Me)
  Result = False
  Exit Sub
ErrHandler:
  Call ErrorHandler("Load_A_COM")
End Sub

Public Sub Unload_A_COM()
On Error GoTo ErrHandler

  Call mo_Tools.Unload_A_ComControls(Me.Controls)
  Call mo_Db.Close(mc_ScreenLabels)
  Set mo_Db = Nothing
  Set mo_FSO = Nothing
  Exit Sub
ErrHandler:
  Call ErrorHandler("Unload_A_COM")
End Sub


Private Sub btn_Quit_Click()
On Error GoTo ErrHandler
  
  Result = False
  Hide
  Exit Sub
ErrHandler:
  Call ErrorMessage("btn_Quit_Click")
End Sub

Private Sub btn_Validate_Click()
On Error GoTo ErrHandler
  
Dim ls_req As String

  Call mo_Tools.LockScreen(Me, True)
  PRD_Code = Trim(txt_PRD_Code.Text)
  CopyAttributes = chk_Attributes.Value = vbChecked
  CopyBOM = chk_BOM.Value = vbChecked
  CopyBOR = chk_BOR.Value = vbChecked
  
  If (PRD_Code = "") Or ((CopyAttributes = False) And (CopyBOM = False) And (CopyBOM = False)) Then
    Call mo_Tools.LockScreen(Me, False)
    Exit Sub
  End If
  ls_req = "SELECT PRD_Id FROM DPC_PrdCommon WHERE CAT_Id IN ($CAT_Id$) AND PRD_Code=$PRD_Code$"
  ls_req = Replace(ls_req, "$CAT_Id$", mo_Tools.SqlIntIn(Array(eDPCCategory.cgMetalCustomRectPanel, eDPCCategory.cgMetalCustomPanelTemplate, eDPCCategory.cgMetalPanelSKU)), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Code$", mo_Tools.SQLStr(PRD_Code), , , vbTextCompare)
  PRD_Id = mo_Tools.SelectValue(mo_Db, ls_req)
  If (PRD_Id = "") Then
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9856, "#Unknown product code")
    Call mo_Tools.LockScreen(Me, False)
    Exit Sub
  End If
  
  Result = True
  Hide
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("btn_Validate_Click")
End Sub


' display standard error message
Public Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    Dim ls_Message As String
    
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    ls_Message = SCREEN_NAME & " exception. Nr:" & Err.Number & ",Desc: " & ls_errDescription & ",Src:" & ls_ErrSource & "@"
    Call mo_Tools.LogMessage(mo_Db, ml_U_Code, SCREEN_NAME, ls_Message, "E")
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, Me.Name & "." & as_Fct & SEP1 & Err.Source, Err.Description)
End Sub




